#ifndef __LED_H
#define __LED_H

/* 
	Real Time LED Controller, by Mauro Grassi, October 2010.
	
	The LED pin is multiplexed with the voltage doubler circuit for controlling power to the memory card...
	
*/

#include "demo_board_hardware.h"
#include <math.h>

#define LED1								(LATCbits.LATC6)
#define LED1_TRIS							(TRISCbits.TRISC6)
#define LED1_ON								0

#define LED_IP								1

#define LED_IDLE_STATE						0
#define LED_ON_STATE						1
#define LED_ON_HOLD_OFF_STATE				2
#define LED_TURN_OFF_STATE					3
#define LED_OFF_HOLD_OFF_STATE				4
#define LED_REDO_STATE						5

#define MS_LED_TICK_FREQUENCY				(100.0)		    /* in Hz, this is how often the interrupt is called */
#define LED_DIVIDER							(2)
#define T6CON_VALUE							(0x7F)
#define PR6_VALUE							(234)
#define CONVERT_FACTOR_TICKS_TO_MS			((float)1000.0/(float)MS_LED_TICK_FREQUENCY)
#define CONVERT_FACTOR_MS_TO_TICKS			((float)MS_LED_TICK_FREQUENCY/(float)1000.0)

#define STANDARD_LED_OFF_MS					30
#define STANDARD_LED_ON_MS					10
#define STANDARD_LED_OFF_SHORT_MS			5
#define STANDARD_LED_ON_SHORT_MS			5

#define MINIMUM_FLASH_DURATION_MS			(1*(float)CONVERT_FACTOR_TICKS_TO_MS)
#define LED_OFF_HOLDOFF_MS					(15.0)		/* in ms, the hold off after LED on */
#define LED_ON_HOLDOFF_MAX_MS				(250.0)		/* in ms, the maximum on time of the LED */

#define LED_OFF_HOLDOFF_TICKS				((float)LED_OFF_HOLDOFF_MS*(float)CONVERT_FACTOR_MS_TO_TICKS)
#define LED_ON_HOLDOFF_MAX_TICKS			((float)LED_ON_HOLDOFF_MAX_MS*(float)CONVERT_FACTOR_MS_TO_TICKS)

void 				led_Tick(void);
unsigned char 		setLED(unsigned int duration);
unsigned char 		getLED(void);
void 				initLED(void);
unsigned char 		immediateLED(unsigned char c);
void 				powerLED(unsigned char on);
unsigned char 		internalSetLED(unsigned char repeat, unsigned int durationms, unsigned int durationoffms);

extern volatile unsigned int   ledTimer;
extern volatile unsigned int   ledOnTime;
extern volatile unsigned int   ledDelta;
extern volatile unsigned char  ledState;
extern volatile unsigned char  ledRepeat;
extern volatile unsigned int   ledOffTime;
extern volatile unsigned char  ledDivider;

#endif
